//
//  StatusView.m
//  The Obfuscated Path
//
//  Created by ss2cire on 12/15/08.
//  Copyright 2008 GryphonClaw Software. All rights reserved.
//

#import "OPHUDView.h"
#import <OpenGL/gl.h>
#import <GLUT/glut.h>

@implementation OPHUDView
- (id)init
{
	self = [super init];
	if(self != nil) {
		itemsToDraw = [[NSMutableArray alloc] init];
		updateMethod = @selector(update);
		drawMethod = @selector(draw);
	}
	return self;
}

- (void)draw
{
	glPushMatrix();
	glTranslatef(0, 352,0);
	glBegin(GL_QUADS);
		glColor3d(0.0, 0.0, 0.0);
		glVertex2i(0, 0);
		glVertex2i(512, 0);
		glVertex2i(512, 96);
		glVertex2i(0, 96);
	glEnd();
	[itemsToDraw makeObjectsPerformSelector:@selector(draw)];
	glColor3d(1.0, 1.0, 1.0);
	glPopMatrix();
}

- (void)update
{
}

- (void)addItemToDraw:(id)item;
{
	if([item respondsToSelector:updateMethod] && [item respondsToSelector:drawMethod]) {
		[itemsToDraw addObject:item];
	}
}
@end
